create or replace package body tbicds.PCK_INTAKE is

/* Copyright 2016 Intellica Corporation.  

This software is protected by FAR Subpart 27.4 - Rights in Data and Copyrights and 
international treaties.  The software was produced by Intellica Corporation of 
San Antonio, Texas for the Veterans Administration (VA) under Contract Number 
VA118-14-C-0015, Project Number TAC-16-28335 and Project Title, 
'Traumatic Brain Injury Clinical Decision Support (TBI CDS) Implementation'.  
Contract dates: 8 May 2014 - 4 January 2016.  This software was finalized 
and uploaded to the VA's Open Source Electronic Health Record Alliance (OSEHRA) 
on 31 December 2015.  Unauthorized reproduction or distribution of this software 
or any portion of it may result in severe civil and criminal penalties and will 
be prosecuted to the maximum possible extent of the law.

For licensing information contact:  info@intellicacorp.com 
*/

  /*****
  Delete Instrument 
  *****/
  procedure DeleteInstrument(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP  in varchar2,
                             pi_nUserID           in number,
                                     
                             pi_vPatientID        in varchar2,
                             pi_nIntakeID         in number,
                             pi_nMID              in number,
                             pi_nPWEventModuleID  in number,
                                     
                             po_nStatusCode       out number,
                             po_vStatusComment    out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' delete ';
    v_vSQL := v_vSQL || '   from data_intake d ';
    v_vSQL := v_vSQL || '  where d.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '    and d.mid = :MID ';
    v_vSQL := v_vSQL || '    and d.intake_id = :INTAKE_ID ';
  
    --delete intake, cascade del will cleanup children
    execute immediate v_vSQL
    using pi_vPatientID, 
          pi_nMID, 
          pi_nIntakeID; 
    commit;
  
    --update the patient_pw_event to reset the tree leaf
    update pat_pw_event_module t 
    set  t.status = 0,
         t.date_started = null,
         t.date_completed = null,
         t.completed_by = null
    where t.patient_id = pi_vPatientID 
    and t.pw_event_module_id = pi_nPWEventModuleID;
    commit;
    
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;
  
/*get module type*/
procedure GetModuleType(pi_vSessionID       in varchar2,
                        pi_vSessionClientIP in varchar2,
                        pi_nUserID          in number,
                        pi_nMID             in number,
                        po_nModuleType      out number,
                        po_nStatusCode      out number,
                        po_vStatusComment   out varchar2) 
  is
  
  v_nModuleType number := -1;
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    begin
      select m.module_type
        into v_nModuleType
      from tbicds.intake_module m
      where m.active=1
        and m.mid = pi_nMID;
    exception
      when others then
        v_nModuleType := -1;
    end;
                
    po_nModuleType := v_nModuleType;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetModuleType(): ' || sqlErrm;
  end;
  
/*get rs of modules matching search criteria*/
procedure GetAllModuleRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor) 
  is
  
  v_vSQL varchar2(4000) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := 'select s.mid, trim(s.acronym || '' '' || s.module) as module, s.description, s.module_alt_lang, s.module_for from tbicds.intake_module s '
                || 'where s.active=1 '
                || '  and s.module_type=0 '
                || 'order by s.module asc';
                    
    open rs for v_vSQL;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetAllModuleRS(): ' || sqlErrm;
  end;


/*get rs of modules that are scoreable*/
procedure GetAllScorableModuleRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor) 
  is
  
  v_vSQL varchar2(4000) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := 'select * from tbicds.intake_module s '
                || 'where s.active=1 '
                || '  and s.module_type=0 '
                || '  and s.mid in (select mid from intake_module_description where scorable =1) '
                || 'order by s.module asc';
    
    open rs for v_vSQL;
    
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetAllScorableModuleRS(): ' || sqlErrm;
  end;


/*get rs of modules matching search criteria*/
procedure GetModuleSearchRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vSearch          in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor) 
  is
  
  v_vSQL varchar2(4000) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := 'select s.mid, trim(s.acronym || '' '' || s.module) as module, s.description, s.module_alt_lang, s.module_for from tbicds.intake_module s '
                || 'where s.active=1 and s.module_type=0 and UPPER(s.acronym) || '' '' || UPPER(s.module) like :P0 '
                || 'order by s.module asc';
    
    open rs for 
    v_vSQL using UPPER('%'||pi_vSearch||'%');
   
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetModuleSearchRS(): ' || sqlErrm;
  end;

  /*US:5966
  get intake modules by group id*/
  procedure GetModuleGroupMIDRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nModuleGroupID   in number,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
      select t.mid, trim(t.acronym || ' ' || t.module) as module, t.description, t.module_alt_lang, t.module_for, 
             (select count(*) 
              from data_intake_score dis
              where dis.mid = t.mid) as score_count
        from intake_module t, intake_module_group_mid t2
       where t.mid = t2.mid
         and (
                   t2.module_group_id = pi_nModuleGroupID
                   or
                   pi_nModuleGroupID = -1
             )
         
       order by t2.sort_order;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;
  
  /*US:5966
  get intake modules by group id and perform an inner search*/
  procedure GetModuleGroupMIDRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_nModuleGroupID   in number,
                                pi_vSearch          in varchar2,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2,
                                rs                  out RetRefCursor) 
  is
  
  v_vSQL varchar2(4000) := '';
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    v_vSQL := 'select t.mid, trim(t.acronym || '' '' || t.module) as module, t.description, t.module_alt_lang,' 
              || '(select count(*) from data_intake_score dis where dis.mid = t.mid) as score_count '
              || 'from intake_module t, intake_module_group_mid t2 ' 
              || 'where t.mid = t2.mid and t2.module_group_id = :P0 '
              || 'and t.active = 1 and t.module_type=0 and UPPER(t.acronym) || '' '' || UPPER(t.module) like :P1 '
              || 'order by t2.sort_order';
              
    --open recordset
    open rs for 
      v_vSQL 
    using pi_nModuleGroupID,
          UPPER('%'||pi_vSearch||'%');
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;

  /*get module groups by group type id*/
  procedure GetModuleGroupRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             pi_nGroupTypeID     in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    if pi_nGroupTypeID != -1 then
    
      open rs for
      select *
        from intake_module_group t
       where t.module_group_type_id = pi_nGroupTypeID
       order by sort_order;
    
    else
    
       open rs for
       select -1 as MODULE_GROUP_ID,
             'All' as MODULE_GROUP_DESCR,
             1 as SORT_ORDER,
             'All' as DESCRIPTION,
             -1 as EVENT_ID,
             1 as ACTIVE,
             0 as STAT_MODALITY_ID,
             -1 as MODULE_GROUP_TYPE_ID
      from dual;
      
      end if;
              
      
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;

  /*get module group types such as domain and clinical setting*/
  procedure GetModuleGroupTypeRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor)
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
    
      select i.*
        from tbicds.intake_module_group_type i
       where i.active = 1
       order by sort_order;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;

  /*get resposne load recordset*/
  procedure GetResponseLoadRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vLoadTable       in varchar2,
                              pi_vLoadField       in varchar2,
                              pi_vLoadFilter      in varchar2,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out RetRefCursor) 
  is
  
    strSQL long;
  
  begin
  
    strSQL            := '';
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    strSQL := strSQL || 'SELECT ' || pi_vLoadField;
    strSQL := strSQL || ' FROM ' || case
                when (lower(pi_vLoadTable) not like 'tbicds.%') then
                 'tbicds.'
              end || pi_vLoadTable;
  
    if length(pi_vLoadFilter) > 2 then
      strSQL := strSQL || ' ' || pi_vLoadFilter;
    end if;
  
    --open recordset
    open rs for strSQL;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetResponseLoadRS(): ' || sqlErrm;
  end;

  /*get intake module recordset*/
  procedure GetIntakeModulesRS(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2,
                               rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
    
      select i.*
        from tbicds.intake_module i
       where i.active = 1
      --and i.module_for = 1
        and i.module_type = 0
       order by sort_order;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetIntakeModulesRS(): ' || sqlErrm;
  end;

  /*Get module group recordset*/
  procedure GetModuleGroupRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
      select *
        from tbicds.intake_module_group t
       where t.active = 1
       order by t.module_group_id;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetModuleGroupRS(): ' || sqlErrm;
  end;

  /*Get module list recordset*/
  procedure GetModulesListRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP in varchar2,
                             pi_nUserID          in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
  is
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    --open recordset
    open rs for
      select m.module_group_id,
             m.mid,
             m.sort_order,
             m2.module,
             m2.description
        from (select imgm.*, img.module_group_descr
                from tbicds.intake_module_group_mid imgm,
                     tbicds.intake_module_group     img,
                     tbicds.intake_module           im
               where img.module_group_id = imgm.module_group_id
                 and im.mid = imgm.mid
                 and im.active = 1
                 and im.module_type = 0) m
        left join (select * from tbicds.intake_module im where im.active = 1 and im.module_type = 0) m2
          on m2.mid = m.mid
       order by m.module_group_id, m.sort_order;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetModulesListRS(): ' || sqlErrm;
  end;

  /*start the module*/
  procedure StartModule(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           
                           pi_vPatientID in varchar2,
                           pi_nMID       in number,
                           pi_nGroupID   in number,
                           pi_nIntakeID  in number,
                           
                           po_nStatusCode    out number,
                           po_vStatusComment out varchar2) 
  is
  
  v_dtSysDate date := null;
  v_nExists   number := 0;
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
    
    v_dtSysDate := sysdate;   
    
    begin
      select 1 
        into v_nExists
      from data_intake
      where patient_id = pi_vPatientID
        and intake_id = pi_nIntakeID
        and mid = pi_nMID;
    exception
      when others then
      v_nExists := 0;
    end;
    
    if v_nExists = 0 then
       --insert...    
       insert into data_intake
       (patient_id,
       intake_id,
       mid,
       start_date)
       values
       (pi_vPatientID,
       pi_nIntakeID,
       pi_nMID,
       v_dtSysDate);
       commit;
    else
      --update...
      update data_intake set
       start_date = v_dtSysDate
      where patient_id = pi_vPatientID
        and intake_id = pi_nIntakeID
        and mid = pi_nMID;
      commit;
    end if;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.StartModule(): ' || sqlErrm;
  end;
  
  /*Mark module complete*/
  procedure CompleteModule(pi_vSessionID       in varchar2,
                           pi_vSessionClientIP in varchar2,
                           pi_nUserID          in number,
                           
                           pi_vPatientID in varchar2,
                           pi_nMID       in number,
                           pi_nGroupID   in number,
                           pi_nIntakeID  in number,
                           
                           po_nStatusCode    out number,
                           po_vStatusComment out varchar2) 
  is
  
  v_dtSysDate date := null;
  
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
    
    v_dtSysDate := sysdate;   
      
    --update...
       update data_intake set
         complete = 1,
         complete_date = v_dtSysDate
       where patient_id = pi_vPatientID
         and intake_id = pi_nIntakeID
         and mid = pi_nMID;
       
    --AUDIT TRAIL
    update data_intake_responses_audit set complete_date = v_dtSysDate
    where patient_id = pi_vPatientID
      and mid = pi_nMID
      and intake_id = pi_nIntakeID
      and complete_date is null;
      
    update data_intake_score_audit set complete_date = v_dtSysDate
    where patient_id = pi_vPatientID
      and mid = pi_nMID
      and intake_id = pi_nIntakeID
      and complete_date is null;
       
    commit;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.CompleteModule(): ' || sqlErrm;
  end;


  /*Get score data as a string*/
  PROCEDURE GetScoreDataStringRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                 pi_vPatientID       in varchar2,
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2,
                                 rs                  out RetRefCursor)
  
   is
  
    v_vPatientID  VARCHAR2(50) := pi_vPatientID;
    v_nEncTypeID  NUMBER := 99;
    v_nMaxSeries  NUMBER := 1;
    v_nCurrSeries NUMBER := 1;
    v_nCurrMID    NUMBER := 0;
    v_dtRespDate  DATE := null;
    v_vLabel      VARCHAR2(32767) := NULL;
    v_vDATA       VARCHAR2(32767) := '';
    curEnc        RetRefCursor;
   -- CURSOR curMID IS
   --   SELECT DISTINCT mid
   --     FROM tbicds.encounter_intake_score s
   --    WHERE s.encounter_id IN
   --          (SELECT encounter_id
   --             FROM tbicds.encounter e
   --            WHERE e.patient_id = v_vPatientID
   --              AND e.encounter_type_id = v_nEncTypeID)
   --    ORDER BY mid;
  BEGIN
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
  
    -- open the string
    v_vDATA := v_vDATA || '[';
  /*  FOR recMID IN curMID LOOP
      BEGIN
        SELECT MAX(series)
          INTO v_nMaxSeries
          FROM tbicds.encounter_intake_score
         WHERE mid = recMID.mid
           AND encounter_id IN
               (SELECT encounter_id
                  FROM tbicds.encounter e
                 WHERE e.patient_id = v_vPatientID
                   AND e.encounter_type_id = v_nEncTypeID);
      EXCEPTION
        WHEN OTHERS THEN
          v_nMaxSeries := 1;
      END;
      -- write segment: {"mid": ####, "mid_data": [
      v_vDATA := v_vDATA || '{"mid": ' || TO_CHAR(recMID.mid) ||
                 ', "mid_data": [';
      FOR n IN 1 .. v_nMaxSeries LOOP
        v_nCurrSeries := n;
        v_vDATA       := v_vDATA || '{"data": [';
        FOR recEnc IN (SELECT t1.*, t2.encounter_date
                         FROM tbicds.encounter_intake_score t1,
                              tbicds.encounter              t2
                        WHERE t2.encounter_id = t1.encounter_id
                          AND mid = recMID.mid
                          AND series = n
                          AND t2.encounter_id IN
                              (SELECT DISTINCT encounter_id
                                 FROM tbicds.encounter
                                WHERE encounter_type_id = v_nEncTypeID
                                  AND patient_id = v_vPatientID)
                        ORDER BY t2.encounter_date, t1.encounter_intake_id) LOOP
          --get the date of the assessment not the encounter
          begin
            select max(r.response_datetime)
              into v_dtRespDate
              from tbicds.encounter_intake_responses r
             where r.encounter_id = recEnc.Encounter_Id
               and r.mid = recEnc.mid
               and r.encounter_intake_id = recEnc.Encounter_Intake_Id;
          exception
            when others then
              v_dtRespDate := recEnc.Encounter_Date;
          end;
        
          --write the POINT data
          v_vDATA := v_vDATA || '["' || TO_CHAR(v_dtRespDate, 'mm/dd/yyyy') ||
                     '", "' || TO_CHAR(recEnc.score) || '"],';
          IF (recMID.mid IN (3016, 3020)) THEN
            IF recEnc.interpret IS NOT NULL THEN
              v_vLabel := recEnc.interpret;
            END IF;
          END IF;
        END LOOP;
        v_vDATA := SUBSTR(v_vDATA, 1, LENGTH(v_vDATA) - 1);
        v_vDATA := v_vDATA || ']';
        IF (v_vLabel IS NOT NULL OR LENGTH(v_vLabel) > 0) THEN
          v_vDATA  := v_vDATA || ', "label": "' || v_vLabel || '" ';
          v_vLabel := null;
        END IF;
        v_vDATA := v_vDATA || '},';
      END LOOP;
      -- close the string here
      v_vDATA := SUBSTR(v_vDATA, 1, LENGTH(v_vDATA) - 1);
      v_vDATA := v_vDATA || ']},';
    END LOOP;
    -- ******************************
    -- END OF LOOPS
    if LENGTH(v_vDATA) > 1 then
      v_vDATA := SUBSTR(v_vDATA, 1, LENGTH(v_vDATA) - 1);
    end if;
    v_vDATA := v_vDATA || ']';
    --dbms_output.put_line(v_vDATA);
  
    OPEN rs FOR
      SELECT v_vDATA AS mid_data FROM dual;*/
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := 'PCK_INTAKE.GetScoreDataStringRS(): ' || sqlErrm;
  END;
  
  /*****
  Gets next module intake_id
  *****/
  procedure GetNextMIDIntakeIDRS(pi_vSessionID       in varchar2,
                             pi_vSessionClientIP   in varchar2,
                             pi_nUserID            in number,
                             pi_vPatientID          in varchar2,
                             pi_nMID                in number,
                             po_nStatusCode      out number,
                             po_vStatusComment   out varchar2,
                             rs                  out RetRefCursor) 
  is
  v_nIntakeID number;
  begin
  
    po_nStatusCode    := 0; --0 = success
    po_vStatusComment := '';
    
    -- v_nIntakeID := fngetlastintakeid(pi_vPatientID, pi_nMID) + 1;
    select seqintakeid.nextval into v_nIntakeID from dual;  
  
    --open recordset
    open rs for
      select v_nIntakeID as intake_id
        from dual;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

end;
/

